import { Controller, Get, Delete, Param, Query, UseGuards } from '@nestjs/common';
import { AdminService } from './admin.service';
import { JwtAuthGuard, SuperAdminGuard } from '../auth/guards';

@Controller('admin')
@UseGuards(JwtAuthGuard, SuperAdminGuard)
export class AdminController {
  constructor(private admin: AdminService) {}

  @Get('tenants')
  async listTenants(
    @Query('page') page?: string,
    @Query('limit') limit?: string,
  ) {
    const p = Math.max(1, parseInt(page ?? '1', 10));
    const l = Math.min(100, Math.max(1, parseInt(limit ?? '20', 10)));
    return this.admin.listTenants(p, l);
  }

  @Get('tenants/:id')
  async getTenant(@Param('id') id: string) {
    return this.admin.getTenant(id);
  }

  @Delete('tenants/:id')
  async softDeleteTenant(@Param('id') id: string) {
    return this.admin.softDeleteTenant(id);
  }

  @Get('analytics')
  async analytics() {
    return this.admin.getBasicAnalytics();
  }
}