import { Injectable, CanActivate, ExecutionContext, ForbiddenException } from '@nestjs/common';

@Injectable()
export class SuperAdminGuard implements CanActivate {
  canActivate(context: ExecutionContext): boolean {
    const req = context.switchToHttp().getRequest();
    if (req.user?.platformRole === 'super_admin') return true;
    throw new ForbiddenException('Sadece platform yöneticisi erişebilir');
  }
}
