import { Injectable, CanActivate, ExecutionContext, ForbiddenException } from '@nestjs/common';
import { PrismaService } from '../../prisma/prisma.service';

@Injectable()
export class TenantGuard implements CanActivate {
  constructor(private prisma: PrismaService) {}

  async canActivate(context: ExecutionContext): Promise<boolean> {
    const req = context.switchToHttp().getRequest();
    const user = req.user;
    if (!user) return false;
    if (user.platformRole === 'super_admin') return true;
    const tenantId = user.tenantId ?? req.params?.tenantId ?? req.body?.tenantId;
    if (!tenantId) throw new ForbiddenException('Tenant gerekli');
    const membership = await this.prisma.userTenant.findUnique({
      where: { userId_tenantId: { userId: user.id, tenantId } },
    });
    if (!membership) throw new ForbiddenException('Bu restorana erişim yetkiniz yok');
    req.tenantId = tenantId;
    req.tenantRole = membership.role;
    return true;
  }
}
