import { IsArray, IsEnum, IsOptional, IsUUID } from 'class-validator';

export class BulkProductActionDto {
  @IsArray()
  @IsUUID('4', { each: true })
  productIds: string[];

  @IsEnum(['move_category', 'set_active', 'set_inactive'])
  action: 'move_category' | 'set_active' | 'set_inactive';

  @IsOptional()
  @IsUUID()
  categoryId?: string;
}
