import { IsString, IsUUID, MinLength, IsOptional } from 'class-validator';

export class CreateTableDto {
  @IsString()
  @MinLength(1)
  name: string;

  @IsUUID()
  locationId: string;
}

export class UpdateTableDto {
  @IsString()
  @MinLength(1)
  @IsOptional()
  name?: string;

  @IsUUID()
  @IsOptional()
  locationId?: string;
}
