import { Injectable } from '@nestjs/common';
import * as QRCode from 'qrcode';

@Injectable()
export class QrService {
  async toPng(url: string, size = 256): Promise<Buffer> {
    return QRCode.toBuffer(url, { type: 'png', width: size, margin: 2 });
  }

  async toSvg(url: string, size = 256): Promise<string> {
    return QRCode.toString(url, { type: 'svg', width: size, margin: 2 });
  }
}
