import { IsString, IsEnum, IsUUID } from 'class-validator';

export class PresignedUploadDto {
  @IsString()
  filename: string;

  @IsString()
  contentType: string;

  @IsUUID()
  productId: string;

  @IsEnum(['image', 'model3d'])
  type: 'image' | 'model3d';
}
