export type Locale = 'tr' | 'en';

export const strings: Record<Locale, Record<string, string>> = {
  tr: {
    menu: 'Menü',
    category: 'Kategori',
    product: 'Ürün',
    price: 'Fiyat',
    description: 'Açıklama',
    allergens: 'Alerjenler',
    view3d: '3D Görünüm',
    back: 'Geri',
    table: 'Masa',
    location: 'Şube',
  },
  en: {
    menu: 'Menu',
    category: 'Category',
    product: 'Product',
    price: 'Price',
    description: 'Description',
    allergens: 'Allergens',
    view3d: '3D View',
    back: 'Back',
    table: 'Table',
    location: 'Location',
  },
};

export function t(locale: Locale, key: string): string {
  return strings[locale]?.[key] ?? strings.tr[key] ?? key;
}
