import { StatusBar } from 'expo-status-bar';
import { NavigationContainer } from '@react-navigation/native';
import { createNativeStackNavigator } from '@react-navigation/native-stack';
import { LoginScreen } from './src/screens/LoginScreen';
import { ProductsScreen } from './src/screens/ProductsScreen';
import { ProductEditScreen } from './src/screens/ProductEditScreen';
import { Viewer3DScreen } from './src/screens/Viewer3DScreen';

const Stack = createNativeStackNavigator();

export default function App() {
  return (
    <>
      <StatusBar style="auto" />
      <NavigationContainer>
        <Stack.Navigator screenOptions={{ headerShown: true }}>
          <Stack.Screen name="Login" component={LoginScreen} options={{ title: '3DQR' }} />
          <Stack.Screen name="Products" component={ProductsScreen} options={{ title: 'Ürünler' }} />
          <Stack.Screen name="ProductEdit" component={ProductEditScreen} options={{ title: 'Ürün Düzenle' }} />
          <Stack.Screen name="Viewer3D" component={Viewer3DScreen} options={{ title: '3D Görünüm' }} />
        </Stack.Navigator>
      </NavigationContainer>
    </>
  );
}
