import { View, StyleSheet } from 'react-native';
import { WebView } from 'react-native-webview';

const viewerHtml = (modelUrl: string, productName: string) => `
<!DOCTYPE html>
<html>
<head>
  <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
  <script type="module" src="https://unpkg.com/@google/model-viewer/dist/model-viewer.min.js"></script>
  <style>
    * { margin: 0; padding: 0; box-sizing: border-box; }
    html, body { width: 100%; height: 100%; background: #000; }
    model-viewer { width: 100%; height: 100%; }
  </style>
</head>
<body>
  <model-viewer
    src="${modelUrl.replace(/"/g, '&quot;')}"
    alt="${productName.replace(/"/g, '&quot;')}"
    auto-rotate
    camera-controls
    style="width:100%;height:100%"
  ></model-viewer>
</body>
</html>
`;

export function Viewer3DScreen({ route }: any) {
  const { url, name } = route.params || {};

  if (!url) {
    return null;
  }

  return (
    <View style={styles.container}>
      <WebView
        source={{ html: viewerHtml(url, name || '3D Model') }}
        style={styles.webview}
        scrollEnabled={false}
        bounces={false}
      />
    </View>
  );
}

const styles = StyleSheet.create({
  container: { flex: 1, backgroundColor: '#000' },
  webview: { flex: 1 },
});
