'use client';

import { useEffect, useState } from 'react';
import Link from 'next/link';
import { tenantApi } from '@/lib/api';

export default function DashboardPage() {
  const [data, setData] = useState<any>(null);

  useEffect(() => {
    tenantApi.getMe().then(setData);
  }, []);

  if (!data) return null;

  const menuUrl = typeof window !== 'undefined'
    ? `${window.location.origin.replace('app.', 'menu.')}/r/${data.slug}`
    : `https://menu.domain.com/r/${data.slug}`;

  return (
    <div>
      <h1 className="text-2xl font-bold text-slate-800 mb-6">Özet</h1>
      <div className="grid grid-cols-1 md:grid-cols-3 gap-4 mb-8">
        <div className="bg-white rounded-xl border border-slate-200 p-4">
          <p className="text-sm text-slate-500">Ürün sayısı</p>
          <p className="text-2xl font-semibold text-slate-800">{data._count?.products ?? 0}</p>
        </div>
        <div className="bg-white rounded-xl border border-slate-200 p-4">
          <p className="text-sm text-slate-500">Şube sayısı</p>
          <p className="text-2xl font-semibold text-slate-800">{data._count?.locations ?? 0}</p>
        </div>
        <div className="bg-white rounded-xl border border-slate-200 p-4">
          <p className="text-sm text-slate-500">Abonelik</p>
          <p className="text-lg font-semibold text-slate-800 capitalize">
            {data.subscription?.status ?? '—'}
          </p>
        </div>
      </div>
      <div className="bg-white rounded-xl border border-slate-200 p-4">
        <h2 className="font-semibold text-slate-800 mb-2">Menü linki</h2>
        <p className="text-sm text-slate-600 font-mono break-all">{menuUrl}</p>
        <Link
          href="/dashboard/qr"
          className="inline-block mt-2 text-emerald-600 hover:underline text-sm font-medium"
        >
          QR kodları oluştur →
        </Link>
      </div>
    </div>
  );
}
