import { z } from 'zod';

export const registerBodySchema = z.object({
  email: z.string().email(),
  password: z.string().min(8, 'En az 8 karakter'),
  name: z.string().min(1),
  tenantName: z.string().min(1, 'Restoran adı gerekli'),
  tenantSlug: z.string().min(2).regex(/^[a-z0-9-]+$/, 'Sadece küçük harf, rakam ve tire'),
});

export const loginBodySchema = z.object({
  email: z.string().email(),
  password: z.string().min(1),
});

export const refreshBodySchema = z.object({}).optional();

export type RegisterBody = z.infer<typeof registerBodySchema>;
export type LoginBody = z.infer<typeof loginBodySchema>;
