import { z } from 'zod';

export const createLocationSchema = z.object({
  name: z.string().min(1),
  address: z.string().optional(),
  city: z.string().optional(),
  country: z.string().optional(),
});

export const updateLocationSchema = createLocationSchema.partial();

export const createTableSchema = z.object({
  name: z.string().min(1),
  locationId: z.string().uuid(),
});

export const updateTableSchema = z.object({
  name: z.string().min(1).optional(),
  locationId: z.string().uuid().optional(),
});

export type CreateLocationBody = z.infer<typeof createLocationSchema>;
export type UpdateLocationBody = z.infer<typeof updateLocationSchema>;
export type CreateTableBody = z.infer<typeof createTableSchema>;
export type UpdateTableBody = z.infer<typeof updateTableSchema>;
