import { z } from 'zod';

const allowedImageMimes = ['image/jpeg', 'image/png', 'image/webp'];
const allowedModelMimes = ['model/gltf-binary', 'model/gltf+json'];

export const presignedUploadSchema = z.object({
  filename: z.string().min(1),
  contentType: z.string().refine(
    (v) => [...allowedImageMimes, ...allowedModelMimes].includes(v),
    { message: 'Geçersiz dosya tipi' }
  ),
  productId: z.string().uuid(),
  type: z.enum(['image', 'model3d']),
});

export type PresignedUploadBody = z.infer<typeof presignedUploadSchema>;

export const MAX_IMAGE_SIZE_BYTES = 5 * 1024 * 1024; // 5MB
export const MAX_MODEL_SIZE_BYTES = 20 * 1024 * 1024; // 20MB

export function getAllowedMimes(type: 'image' | 'model3d'): string[] {
  return type === 'image' ? allowedImageMimes : allowedModelMimes;
}
