<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Content-Type: application/json; charset=UTF-8");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

$host = "localhost";
$db_name = "celikevimcom_form";
$username = "celikevimcom_form";
$password = "your_password_here"; // CHANGE THIS

try {
    $conn = new PDO("mysql:host=" . $host . ";dbname=" . $db_name . ";charset=utf8", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $exception) {
    http_response_code(500);
    echo json_encode(["status" => "error", "message" => "Database connection failed"]);
    exit();
}

$action = $_GET['action'] ?? '';

// LOGIN
if ($action === 'login' && $_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents("php://input"));
    $email = $data->email ?? '';
    $pass = $data->password ?? '';

    $stmt = $conn->prepare("SELECT * FROM users WHERE email = :email");
    $stmt->execute([':email' => $email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && password_verify($pass, $user['password_hash'])) {
        // Token: hex encoded json (safe for URLs)
        $token = bin2hex(json_encode(['id' => $user['id'], 'time' => time()]));
        echo json_encode(["status" => "success", "token" => $token, "user" => ["email" => $user['email']]]);
    } else {
        http_response_code(401);
        echo json_encode(["status" => "error", "message" => "Invalid credentials"]);
    }
    exit();
}

// GET SUBMISSIONS (Protected)
if ($action === 'get_submissions' && $_SERVER['REQUEST_METHOD'] === 'GET') {
    // Token verification via Query Param (Reliable on all hostings)
    $token = $_GET['token'] ?? '';

    // Decode from hex
    $json_str = @hex2bin($token);
    $decoded = json_decode($json_str, true);

    if (!$decoded || !isset($decoded['id'])) {
        http_response_code(401);
        echo json_encode(["status" => "error", "message" => "Unauthorized: Invalid Token"]);
        exit();
    }

    $stmt = $conn->prepare("SELECT * FROM form_submissions ORDER BY created_at DESC");
    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($rows);
    exit();
}

// Create Initial Admin
if ($action === 'create_admin') {
    $email = "bilalpolat2002@mail.com";
    $pass = "12345678";
    $hash = password_hash($pass, PASSWORD_DEFAULT);

    try {
        $stmt = $conn->prepare("INSERT INTO users (email, password_hash) VALUES (:email, :hash)");
        $stmt->execute([':email' => $email, ':hash' => $hash]);
        echo "Admin created.";
    } catch (PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
}
?>