<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Content-Type: application/json; charset=UTF-8");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

$host = "localhost";
$db_name = "celikevimcom_form";
$username = "celikevimcom_user";
$password = "your_password_here"; // CHANGE THIS

try {
    $conn = new PDO("mysql:host=" . $host . ";dbname=" . $db_name . ";charset=utf8", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $exception) {
    http_response_code(500);
    echo json_encode(["status" => "error", "message" => "Database connection failed"]);
    exit();
}

$data = json_decode(file_get_contents("php://input"));

if ($data) {
    $query = "INSERT INTO form_submissions SET 
        service_type=:service, 
        heizung_type=:heizung, 
        warmepumpe_type=:warmepumpe,
        solarthermie_type=:solarthermie,
        solarthermie_area=:solarthermieArea,
        pufferspeicher=:pufferspeicher,
        building_type=:buildingType,
        construction_year=:constructionYear,
        funding_type=:funding,
        post_code=:postCode,
        first_name=:firstName,
        last_name=:lastName,
        street_address=:street,
        city=:city,
        email=:email,
        country_code=:countryCode,
        phone_number=:phone";

    $stmt = $conn->prepare($query);

    // Bind values
    $stmt->bindValue(':service', $data->service ?? '');
    $stmt->bindValue(':heizung', $data->heizungType ?? '');
    $stmt->bindValue(':warmepumpe', $data->warmepumpeType ?? '');
    $stmt->bindValue(':solarthermie', $data->solarthermieType ?? '');
    $stmt->bindValue(':solarthermieArea', $data->solarthermieArea ?? '');
    $stmt->bindValue(':pufferspeicher', $data->pufferspeicher ?? '');
    $stmt->bindValue(':buildingType', $data->buildingType ?? '');
    $stmt->bindValue(':constructionYear', $data->constructionYear ?? '');
    $stmt->bindValue(':funding', $data->funding ?? '');
    $stmt->bindValue(':postCode', $data->postCode ?? '');
    $stmt->bindValue(':firstName', $data->firstName ?? '');
    $stmt->bindValue(':lastName', $data->lastName ?? '');
    $stmt->bindValue(':street', $data->street ?? '');
    $stmt->bindValue(':city', $data->city ?? '');
    $stmt->bindValue(':email', $data->email ?? '');
    $stmt->bindValue(':countryCode', $data->countryCode ?? ''); // Changed from phoneCode
    $stmt->bindValue(':phone', $data->phone ?? '');    // Changed from phoneNumber

    if ($stmt->execute()) {
        echo json_encode(["status" => "success", "message" => "Form submitted successfully."]);
    } else {
        http_response_code(500);
        echo json_encode(["status" => "error", "message" => "Unable to save data."]);
    }
} else {
    http_response_code(400);
    echo json_encode(["status" => "error", "message" => "No data received."]);
}
?>